function [logL,gradlogL,HessianlogL] = likelihood(M,mu,dmudtheta,varfit)
% returns the log-likelihood, as well as first and second order
% derivatives w.r.t. the parameters for a noisy image M, measured in
% number of photons per pixel, and Poisson-rate mu with first order
% derivatives dmudtheta. The log-likelihood is Poisson+readout-noise based.

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

numparams = size(dmudtheta,3);

% calculation of weight factors
keps = 1e3*eps;
mupos = double(mu>0).*mu + double(mu<0)*keps;
weight = (M-mupos)./(mupos+varfit);
dweight = (M+varfit)./(mupos+varfit).^2;

logL = sum(sum( (M+varfit).*log(mupos+varfit)-(mupos+varfit) ));

gradlogL = zeros(1,numparams);
HessianlogL = zeros(numparams,numparams);
for ii = 1:numparams
  gradlogL(ii) = sum(sum( weight.*dmudtheta(:,:,ii) ));
  for jj = 1:numparams
    HessianlogL(ii,jj) = sum(sum(-dweight.*dmudtheta(:,:,ii).*dmudtheta(:,:,jj)));
  end
end

return